clc
clear all
close all
n1=200;
n2=200;
alpha=linspace(0.14,0.35,n1); %Range of input strength
m=linspace(80,200,n2)./48;%Range of feedback inh. stre.
tic
state = zeros(n1,n2);
for i=1:n1
    parfor j=1:n2
        [~,state(i,j)] = omega_simulate(alpha(i),m(j));
    end
    disp(i/n1);
end
toc
save state_final.mat

%%%%%%%%%%%%%%%%%%fig_3B
clc
clear all
close all
load state_final.mat
[M,Alpha]=meshgrid(m,alpha);
surf(M,Alpha,state),
colorbar
view([0 0 1])
set(gcf,'unit','centimeters','position',[25,17,12,8])
axis([min(m) max(m) min(alpha) max(alpha)])
xlabel('feedback inh. stre. m','fontname','Arial')
ylabel('input stre. \alpha','fontname','Arial')
colorbar
box on
set(gca,'linewidth',3,'fontsize',15,'fontname','Arial');